const jwt= require("jsonwebtoken");

const verifyToken =(req,res,next)=>{
    const authHeader =req.headers.authorization
    if(authHeader){
        const token =authHeader.split(" ")[1];
        jwt.verify(token,process.env.JWT_SEC,(err,user)=>{
            if(err) return res.status(403).json("Token is not valid!")
            req.user=user
            next()
        })
    }else{
        return res.status(401).json("Your are not authentificated!")
    }
}

const verifyTokenAndAuthorization =(req,res,next)=>{
    verifyToken(req,res,()=>{
        if(req.user.id===req.params.id){
            next()
        }else{
            res.status(403).json("You are not alowed to do that!")

        }
    })
}
module.exports = {verifyToken,verifyTokenAndAuthorization}